/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.huts;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowModuleBuilding;
import com.minecolonies.coremod.client.gui.WindowAssignCitizen;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.RecallCitizenHutMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.NotNull;

public class WindowHutTavern
extends AbstractWindowModuleBuilding<TavernBuildingModule.View> {
    private static final String BUTTON_ASSIGN = "assign";
    private static final String BUTTON_REMOVE = "remove";
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowhuthome.xml";
    private static final String LIST_CITIZEN = "assignedCitizen";
    private final LivingBuildingView home;
    private ScrollingList citizen;

    public WindowHutTavern(TavernBuildingModule.View building) {
        super(building, "minecolonies:gui/windowhuthome.xml");
        super.registerButton(BUTTON_ASSIGN, this::assignClicked);
        super.registerButton(BUTTON_REMOVE, this::removeClicked);
        super.registerButton("recall", this::recallClicked);
        this.home = building;
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenHutMessage((AbstractBuildingView)this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.citizen = (ScrollingList)this.findPaneOfTypeByID(LIST_CITIZEN, ScrollingList.class);
        this.citizen.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutTavern.this.home.getResidents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowHutTavern.this.home.getColony().getCitizen(WindowHutTavern.this.home.getResidents().get(index));
                if (citizenDataView != null) {
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(citizenDataView.getName());
                    ((Button)rowPane.findPaneOfTypeByID(WindowHutTavern.BUTTON_REMOVE, Button.class)).setEnabled(((TavernBuildingModule.View)WindowHutTavern.this.building).getColony().isManualHousing());
                }
            }
        });
        this.refreshView();
    }

    private void refreshView() {
        Button buttonAssign = (Button)this.findPaneOfTypeByID(BUTTON_ASSIGN, Button.class);
        int sparePlaces = 4 - ((TavernBuildingModule.View)this.building).getResidents().size();
        buttonAssign.setText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.home.assign", (Object[])new Object[]{sparePlaces}));
        buttonAssign.setEnabled(sparePlaces > 0 && ((TavernBuildingModule.View)this.building).getColony().isManualHousing());
        this.citizen.refreshElementPanes();
    }

    private void assignClicked() {
        if (((TavernBuildingModule.View)this.building).getColony().isManualHousing()) {
            if (((TavernBuildingModule.View)this.building).getBuildingLevel() == 0) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.workerhuts.level0", (Object[])new Object[0]);
                return;
            }
            if (((TavernBuildingModule.View)this.building).getResidents().size() < 4) {
                WindowAssignCitizen window = new WindowAssignCitizen(((TavernBuildingModule.View)this.building).getColony(), ((TavernBuildingModule.View)this.building).getPosition());
                window.open();
            }
        }
    }

    private void removeClicked(@NotNull Button button) {
        if (((TavernBuildingModule.View)this.building).getColony().isManualHousing()) {
            int row = this.citizen.getListElementIndexByPane((Pane)button);
            int citizenid = this.home.getResidents().get(row);
            this.home.removeResident(row);
            Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, false, citizenid));
            this.refreshView();
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.tavern";
    }
}

